/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.source;

import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import dev.lambdaurora.lambdynlights.engine.CellHasher;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.engine.lookup.SpatialLookupDeferredEntry;
import dev.lambdaurora.lambdynlights.engine.lookup.SpatialLookupEntry;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;

public final class DeferredDynamicLightSource
implements DynamicLightSource {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    private final int id = ID_COUNTER.getAndIncrement();
    private final DynamicLightBehavior behavior;
    private DynamicLightBehavior.BoundingBox previousBoundingBox;

    public DeferredDynamicLightSource(DynamicLightBehavior behavior) {
        this.behavior = behavior;
        this.previousBoundingBox = null;
    }

    public DynamicLightBehavior behavior() {
        return this.behavior;
    }

    @Override
    public int getDynamicLightId() {
        return this.id;
    }

    @Override
    public Stream<SpatialLookupEntry> splitIntoDynamicLightEntries(@NotNull CellHasher cellHasher) {
        DynamicLightBehavior.BoundingBox boundingBox = this.behavior.getBoundingBox();
        ArrayList<SpatialLookupDeferredEntry> chunks = new ArrayList<SpatialLookupDeferredEntry>();
        int cellEndX = DynamicLightingEngine.positionToCell(boundingBox.endX());
        int cellEndY = DynamicLightingEngine.positionToCell(boundingBox.endY());
        int cellEndZ = DynamicLightingEngine.positionToCell(boundingBox.endZ());
        for (int x = DynamicLightingEngine.positionToCell(boundingBox.startX()); x <= cellEndX; ++x) {
            for (int y = DynamicLightingEngine.positionToCell(boundingBox.startY()); y <= cellEndY; ++y) {
                for (int z = DynamicLightingEngine.positionToCell(boundingBox.startZ()); z <= cellEndZ; ++z) {
                    chunks.add(new SpatialLookupDeferredEntry(cellHasher.hashCell(x, y, z), this.behavior));
                }
            }
        }
        return chunks.stream();
    }

    @Override
    public Long2ObjectMap<ChunkRebuildStatus> getDynamicLightChunksToRebuild(boolean forced) {
        if (!forced && !this.behavior.hasChanged()) {
            return Long2ObjectMaps.emptyMap();
        }
        DynamicLightBehavior.BoundingBox boundingBox = this.behavior.getBoundingBox();
        Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap();
        if (this.previousBoundingBox != null) {
            DeferredDynamicLightSource.addBoundingBoxToChunksSet(this.previousBoundingBox, chunk -> chunks.put(chunk, (Object)ChunkRebuildStatus.REMOVE_REQUESTED));
        }
        DeferredDynamicLightSource.addBoundingBoxToChunksSet(boundingBox, chunk -> chunks.put(chunk, (Object)ChunkRebuildStatus.REQUESTED));
        this.previousBoundingBox = boundingBox;
        return chunks;
    }

    private static void addBoundingBoxToChunksSet(DynamicLightBehavior.BoundingBox boundingBox, LongConsumer consumer) {
        int chunkStartX = DeferredDynamicLightSource.getStartChunk(boundingBox.startX());
        int chunkStartY = DeferredDynamicLightSource.getStartChunk(boundingBox.startY());
        int chunkStartZ = DeferredDynamicLightSource.getStartChunk(boundingBox.startZ());
        int chunkEndX = DeferredDynamicLightSource.getEndChunk(boundingBox.endX());
        int chunkEndY = DeferredDynamicLightSource.getEndChunk(boundingBox.endY());
        int chunkEndZ = DeferredDynamicLightSource.getEndChunk(boundingBox.endZ());
        for (int x = chunkStartX; x <= chunkEndX; ++x) {
            for (int y = chunkStartY; y <= chunkEndY; ++y) {
                for (int z = chunkStartZ; z <= chunkEndZ; ++z) {
                    consumer.accept(class_4076.method_18685((int)x, (int)y, (int)z));
                }
            }
        }
    }

    private static int getStartChunk(int blockPos) {
        int chunkStart = class_4076.method_18675((int)blockPos);
        if ((class_3532.method_15375((float)blockPos) & 0xF) < 8) {
            --chunkStart;
        }
        return chunkStart;
    }

    private static int getEndChunk(int blockPos) {
        int chunkStart = class_4076.method_18675((int)blockPos);
        if ((class_3532.method_15375((float)blockPos) & 0xF) >= 8) {
            ++chunkStart;
        }
        return chunkStart;
    }
}

